/**
 * @author: cll
 * @version:1.0
 * @date: 2021-08-12 17:20
 * @descripton:
 */
package com.fshows.leshuapay.sdk.util.risksign;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.request.merchant.riskmanagement.RiskDetailRequest;
import com.fshows.leshuapay.sdk.util.SignUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

/**
 * @author cll
 * @version RiskDetailSign.java, v 0.1 2021-08-12 17:20 cll 风控详情签名
 */
@Slf4j
public class RiskDetailSign implements LeshuaRiskSign {

    @Override
    public LeshuaBizRequest doSign(Serializable request, String privateKey, String agentId)
            throws LeshuaException {
        try {
            // 签名规则  key= merchantId&ticketNumber&agentKey;
            RiskDetailRequest riskDetailRequest = null;
            if (request instanceof RiskDetailRequest) {
                riskDetailRequest = (RiskDetailRequest) request;
                StringBuffer key = new StringBuffer(riskDetailRequest.getMerchantId());
                key.append("&");
                key.append(riskDetailRequest.getTicketNumber());
                key.append("&");
                key.append(privateKey);
                riskDetailRequest.setSign(SignUtil.doSign(key.toString()));
            }
            return riskDetailRequest;
        } catch (Exception e) {
            log.error("RiskDetailSign->> doSign 签名异常,ex={}", e);
            throw new LeshuaException("风控签名异常", e);
        }
    }
}
