/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 支付宝上报信息
 *
 * @author zhaoyi
 * @version AlipayReportInfo.java, v 0.1 2020-07-29 15:25 zhaoyi
 */
@Data
public class AlipayReportInfo implements Serializable {

    private static final long serialVersionUID = -3782663600715145036L;
    /**
     * 支付宝商户号
     */
    private String subMchId;


    /**
     * 支付宝商户号等级
     */
    private String subMchLevel;

    /**
     * 上报失败时的失败原因
     */
    private String msg;

    /**
     * 创建时间（商户没有上报则为空）
     */
    private String createTime;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }


}
