/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.MultiQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账查询
 *
 * @author linzy
 * @version QueryRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MultiQueryRequest extends LeshuaBizRequest<MultiQueryResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 第三方分账单号
     */
    private String thirdRoyaltyId;

    /**
     * 乐刷分账单号
     */
    private String leshuaRoyaltyId;

    /**
     * 乐刷交易订单号
     */
    private String leshuaOrderId;

    /**
     * 1：查询该笔交易的所有分账信息。
     * <p>
     * 0：查询单笔分账信息
     */
    private Integer allRoyaltyFlag;

    @Override
    public Class<MultiQueryResponse> getResponseClass() {
        return MultiQueryResponse.class;
    }
}
