/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 门店信息
 *
 * @author zhaoyi
 * @version ShopInfo.java, v 0.1 2020-07-27 15:05 zhaoyi
 */
@Data
public class ShopInfo implements Serializable {

    private static final long serialVersionUID = -534634545538181408L;

    /**
     * 店铺类型
     * 1总店 （默认）
     * 0 分店
     */
    private Integer shopType;

    /**
     * 总店商户号，分店必填
     */
    @Length(max = 10, message = "总店商户号超长")
    private String headMerchantId;

    /**
     * 结算对象
     * 0独立结算 （默认）
     * 1合并结算至总店
     */
    private Integer settleTo;

    /**
     * 经营场所内设照片图片地址
     */
    @NotBlank(message = "经营场所内设照片图片地址不能为空")
    private String insidePic;

    /**
     * 门头照图片地址
     */
    @NotBlank(message = "门头照图片地址不能为空")
    private String doorPic;

    /**
     * 收银台照片图片地址
     */
    @NotBlank(message = "收银台照片图片地址不能为空")
    private String cashierDeskPic;
}
