/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.alipay;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.alipay.LeshuaAlipayAntShopQueryResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhangmj
 * @version LeshuaActivitySignRequest.java, v 0.1 2022-03-09 上午9:29 zhangmj
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaAlipayAntShopQueryRequest extends LeshuaBizRequest<LeshuaAlipayAntShopQueryResponse> {

    /**
     * 乐刷商户id
     */
    private String merchantId;

    /**
     * 门店编号
     */
    private String storeId;

    /**
     * 商户角色id
     */
    private String ipRoleId;

    @Override
    public Class<LeshuaAlipayAntShopQueryResponse> getResponseClass() {
        return LeshuaAlipayAntShopQueryResponse.class;
    }
}