/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaGoldActivitySignResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xujw
 * @version LeshuaGoldActivitySignRequest.java, v 0.1 2022-08-23 上午9:29 xujw
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaGoldActivitySignRequest extends LeshuaBizRequest<LeshuaGoldActivitySignResponse> {

    /**
     * 必须	活动id
     */
    private String code;
    /**
     * 必须	商户编号
     */
    private String merchantId;
    /**
     * 非必须	备注
     */
    private String remark;
    /**
     * 必须	开户人，待开卡时必填
     */
    private String settleName;
    /**
     * 必须	0：默认手机号，1：指定手机号
     */
    private Integer mobileType;
    /**
     * 非必须	手机号，指定手机号时必填
     */
    private String mobile;
    /**
     * 非必须	店名，待开卡时必填
     */
    private String shopName;
    /**
     * 签名
     */
    private String sign;

    /**
     * 补贴对象 0=商户  10代理商
     */
    private Integer settleType;

    @Override
    public Class<LeshuaGoldActivitySignResponse> getResponseClass() {
        return LeshuaGoldActivitySignResponse.class;
    }
}