/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 商户审核状态枚举
 *
 * @author zhaoyi
 * @version MerchantStatusEnum.java, v 0.1 2020-08-03 10:56 zhaoyi
 */
public enum MerchantStatusEnum {
    REJECTED("REJECTED", "个人"),
    REVIEW("REVIEW", "个人"),
    PASSED("PASSED", "个人"),
    UNKNOWN("UNKNOWN", "个人"),
    ADD_INFO("ADD_INFO", "个人"),
    AUDITING("AUDITING", "个人"),

    ;

    private String code;
    private String desc;

    MerchantStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static MerchantStatusEnum getByType(String code) {
        MerchantStatusEnum[] valueList = MerchantStatusEnum.values();
        for (MerchantStatusEnum v : valueList) {
            if (v.getCode().equalsIgnoreCase(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
