/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 商户支付配置类型枚举
 *
 * @author zhaoyi
 * @version ConfigTypeEnum.java, v 0.1 2020-08-03 14:36 zhaoyi
 */
public enum ConfigTypeEnum {
    BIND_APPID(1, "绑定APPID（支付）"),
    FOLLOW_APPID(2, "推荐关注APPID"),
    AUTHORIZED_DIRECTORY(3, "授权目录"),
    ;

    private Integer type;
    private String desc;

    ConfigTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ConfigTypeEnum getByType(Integer type) {
        ConfigTypeEnum[] valueList = ConfigTypeEnum.values();
        for (ConfigTypeEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
