/**
 * fshows.com Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.enums.RiskApiEnum;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;

/**
 * @author cll
 * @version LeshuaRiskClient.java, v 0.1 2021-08-12 11:20 cll
 */
public interface LeshuaRiskClient {
    /**
     * 调用风控相关请求
     *
     * @param request 商户风控入参
     * @param url     实际业务请求地址
     * @param timeout 超时设置，单位毫秒
     * @param <T>
     * @return
     * @throws LeshuaException
     * @Param riskApiEnum
     */
    <T> LeshuaBaseResponse<T> execute(
            LeshuaBizRequest<T> request, RiskApiEnum riskApiEnum, String url, Integer timeout)
            throws LeshuaException;

    /**
     * 乐刷风控申诉二期相关请求
     *
     * @param request
     * @param url
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBaseResponse<T> executeHttp(
            LeshuaBizRequest<T> request, String url)
            throws LeshuaException;
}
