/**
 * fshows.com Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;

import java.util.List;

/**
 * @author zhaoyi
 * @version LeshuaMerchantGateWayClient.java, v 0.1 2020-07-23 11:11 AM zhaoyi
 */
public interface LeshuaMerchantGateWayClient {

    /**
     * 调用商户相关请求
     *
     * @param request    商户入参
     * @param url        实际业务请求地址
     * @param timeout    超时设置，单位毫秒
     * @param subAgentId 二代编号. 为空时，则默认使用主代编号
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, String url, Integer timeout, String subAgentId)
            throws LeshuaException;

    /**
     * 调用商户相关请求
     *
     * @param request 商户入参
     * @param url     实际业务请求地址
     * @param timeout 超时设置，单位毫秒
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBaseResponse<List<T>> executeList(
            LeshuaBizRequest<T> request, String url, Integer timeout) throws LeshuaException;

    /**
     * 调用商户相关请求
     *
     * @param request    商户入参
     * @param url        实际业务请求地址
     * @param timeout    超时设置，单位毫秒
     * @param subAgentId 二代编号. 为空时，则默认使用主代编号
     * @return
     * @throws LeshuaException
     */
    LeshuaBaseResponse<String> executeString(LeshuaBizRequest request, String url, Integer timeout, String subAgentId)
            throws LeshuaException;
}
