/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaSubsidyClient;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.util.SignUtil;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaSubsidyClientImpl
implements LeshuaSubsidyClient {
    private static final Logger log = LoggerFactory.getLogger(LeshuaSubsidyClientImpl.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String NO_DATA_URL = "/open-api/agent-subsidy/query-agent-balance";
    private String serverUrl;
    private String agentId;
    private String privateKey;
    private Integer timeout;

    public LeshuaSubsidyClientImpl(String serverUrl, String agentId, String privateKey, Integer timeout) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
        this.privateKey = privateKey;
        this.timeout = timeout;
    }

    @Override
    public <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, String url, Integer timeout) throws LeshuaException {
        ValidateUtil.validateWithThrow(request, new Class[0]);
        String postUrl = this.serverUrl + url;
        JSONObject object = new JSONObject(new LinkedHashMap());
        object.put("version", (Object)"0.0.1");
        object.put("agentId", (Object)this.agentId);
        if (!url.equals(NO_DATA_URL)) {
            object.put("data", request);
        }
        String sign = SignUtil.getSubsidySign(object.toString(), this.privateKey);
        object.put("sign", (Object)sign);
        RequestConfig requestConfig = null;
        requestConfig = timeout == null || timeout <= 0 ? RequestConfig.custom().setConnectionRequestTimeout(10000).setSocketTimeout(10000).setConnectTimeout(10000).build() : RequestConfig.custom().setConnectionRequestTimeout(timeout.intValue()).setSocketTimeout(timeout.intValue()).setConnectTimeout(timeout.intValue()).build();
        HttpPost httpPost = new HttpPost(postUrl);
        httpPost.setConfig(requestConfig);
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            BasicResponseHandler handler = new BasicResponseHandler();
            StringEntity entity = new StringEntity(object.toJSONString(), "utf-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            String responseStr = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)handler);
            log.info("\u4e50\u5237\u8bf7\u6c42\u8fd4\u56de  param={};response={}", JSON.toJSON(request), (Object)responseStr);
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            LeshuaBaseResponse<Object> response = new LeshuaBaseResponse<Object>();
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            String data = jsonObject.toString();
            if (StringUtils.isBlank((CharSequence)data)) {
                LeshuaBaseResponse<Object> leshuaBaseResponse = response;
                return leshuaBaseResponse;
            }
            response.setData(JSON.parseObject((String)data, request.getResponseClass()));
            LeshuaBaseResponse<Object> leshuaBaseResponse = response;
            return leshuaBaseResponse;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4e50\u5237\u5f02\u5e38,request={};msg={}", JSON.toJSON(request), (Object)e.getMessage());
            throw new LeshuaException("\u8c03\u7528\u5931\u8d25", e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edhttpClient\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f,request={};msg={}", JSON.toJSON(request), (Object)e.getMessage());
            }
        }
    }

    private LeshuaSubsidyClientImpl() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaSubsidyClientImpl)) {
            return false;
        }
        LeshuaSubsidyClientImpl other = (LeshuaSubsidyClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaSubsidyClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaSubsidyClientImpl(serverUrl=" + this.getServerUrl() + ", agentId=" + this.getAgentId() + ", privateKey=" + this.getPrivateKey() + ", timeout=" + this.getTimeout() + ")";
    }
}

