/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.LeshuaShareRefundResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 分账退款
 *
 * @author linzy
 * @version RefundRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LeshuaShareRefundRequest extends LeshuaBizRequest<LeshuaShareRefundResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 第三方订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷交易订单号
     */
    private String leshuaOrderId;

    /**
     * 退款金额，单位：分
     */
    private BigDecimal refundAmount;

    /**
     * 第三方退款单号
     */
    private String thirdRefundId;

    /**
     * 第三方分账单号
     */
    private String thirdRoyaltyId;

    /**
     * 乐刷分账单号
     */
    private String leshuaRoyaltyId;

    /**
     * 回调地址
     */
    private String notifyUrl;
    /**
     * 是否具有分账资格，默认1为有资格
     */
    private Integer merchantRoyaltyFlag;

    /**
     * 退款出资模式，默认为0
     * 0：分账发起方出资
     * 1：分账接收方出资
     */
    private String refundMode;

    /**
     * 退款出资详情，refundMode=1时。
     * 示例：[{"accountId":"21545689713","amount":"100","remark":"分账退款"}, {"accountId":"21545689714","amount":"400","remark":"分账退款"}]
     * 字段说明：
     *   accountId-出资方商户编号
     *   amount-出资方出资金额，单位为分，如100=1.00元，不可超过原分账单号分给该出资方的金额。
     *   remark-备注
     */
    private String refundDetails;



    @Override
    public Class<LeshuaShareRefundResponse> getResponseClass() {
        return LeshuaShareRefundResponse.class;
    }
}
