/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantShortNameModifyResponse;
import lombok.Data;

/**
 * 高校分堂分店绑定参数
 *
 * @author buhao
 * @version SubmchBindRequest.java, v 0.1 2020-11-10 10:26 buhao
 */
@Data
public class MerchantShortNameModifyRequest extends LeshuaBizRequest<MerchantShortNameModifyResponse> {
    private static final long serialVersionUID = 7190196113599189812L;

    /**
     * 注意：1、调用该接口前，先调用商户信息修改接口修改简称，审核通过后才允许调用该接口将简称同步到微信
     *      2、微信规定，商户简称一个月只能修改一次
     */

    /**
     * 乐刷商户号
     */
    private String merchantId;
    /**
     * 需要绑定的子商户号
     */
    private String wxSubMchId;

    /**
     * 支付宝子商户号
     */
    private String zfbSubMchId;

    @Override
    public Class<MerchantShortNameModifyResponse> getResponseClass() {
        return MerchantShortNameModifyResponse.class;
    }
}