/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaActivitySignQueryResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhangmj
 * @version LeshuaActivitySignRequest.java, v 0.1 2022-03-09 上午9:29 zhangmj
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaActivitySignQueryRequest extends LeshuaBizRequest<LeshuaActivitySignQueryResponse> {

    /**
     * 乐刷商户id
     */
    private String merchantId;

    /**
     * 支付宝子商户号
     */
    private String zfbSubMchId;

    /**
     * 申请单号
     */
    private String applyId;


    @Override
    public Class<LeshuaActivitySignQueryResponse> getResponseClass() {
        return LeshuaActivitySignQueryResponse.class;
    }
}