/**
 * @author: cll
 * @version:1.0
 * @date: 2021-08-12 17:20
 * @descripton:
 */
package com.fshows.leshuapay.sdk.util.risksign;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.request.merchant.riskmanagement.RiskListRequest;
import com.fshows.leshuapay.sdk.util.SignUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

/**
 * @author cll
 * @version RiskListSign.java, v 0.1 2021-08-12 17:20 cll 风控列表签名
 */
@Slf4j
public class RiskListSign implements LeshuaRiskSign {

    @Override
    public LeshuaBizRequest doSign(Serializable request, String privateKey, String agentId)
            throws LeshuaException {
        try {
            // 签名规则 key= agentId+"&"+agentKey;
            RiskListRequest riskListRequest = null;
            if (request instanceof RiskListRequest) {
                riskListRequest = (RiskListRequest) request;
                StringBuffer key = new StringBuffer(agentId);
                key.append("&");
                key.append(privateKey);
                riskListRequest.setSign(SignUtil.doSign(key.toString()));
            }
            return riskListRequest;
        } catch (Exception e) {
            log.error("RiskListSign->> doSign 签名异常,ex={}", e);
            throw new LeshuaException("风控签名异常", e);
        }
    }
}
