/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 活动标志枚举
 *
 * @author zhaoyi
 * @version ActiveFlagEnum.java, v 0.1 2020-08-03 15:48 zhaoyi
 */
public enum ActiveFlagEnum {
    WXLZ("WXLZ", "微信绿洲"),
    ZFBLH("ZFBLH", "支付宝蓝海"),
    ;

    private String code;
    private String desc;

    ActiveFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActiveFlagEnum getByType(String code) {
        ActiveFlagEnum[] valueList = ActiveFlagEnum.values();
        for (ActiveFlagEnum v : valueList) {
            if (v.getCode().equalsIgnoreCase(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
