/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaSignature {
    private static final Logger log = LoggerFactory.getLogger(LeshuaSignature.class);
    private static final String SECRET_KEY = "key";

    public static String getMD5Sign(Map<String, String> paramMap, Set<String> exludedSignParams, String key) {
        if (paramMap == null || paramMap.isEmpty()) {
            log.warn("\u5f85\u7b7e\u540d\u53c2\u6570map\u4e3a\u7a7a!");
            return null;
        }
        String str2Sign = LeshuaSignature.buildParam4Sign(paramMap, exludedSignParams, key);
        String result = DigestUtils.md5Hex((String)str2Sign).toUpperCase();
        log.info("MD5\u7b7e\u540d\u539f\u59cb\u4e32\uff1a{}\uff0c\u7b7e\u540d\u7ed3\u679c\uff1a{}", new Object[]{str2Sign, result});
        return result;
    }

    public static String generateMd5Sign(Map<String, Object> paramMap, Set<String> exludedSignParams, String key) {
        if (paramMap == null || paramMap.isEmpty()) {
            log.warn("\u5f85\u7b7e\u540d\u53c2\u6570map\u4e3a\u7a7a!");
            return null;
        }
        String str2Sign = LeshuaSignature.generateMd5SignStr(paramMap, exludedSignParams, key);
        String result = DigestUtils.md5Hex((String)str2Sign).toUpperCase();
        log.info("MD5\u7b7e\u540d\u539f\u59cb\u4e32\uff1a{}\uff0c\u7b7e\u540d\u7ed3\u679c\uff1a{}", new Object[]{str2Sign, result});
        return result;
    }

    public static String getSignFromResponseString(String responseString, Set<String> exludedSignParams, String key) throws DocumentException {
        Map<String, String> map = LeshuaSignature.getMapFromXML(responseString);
        return LeshuaSignature.getMD5Sign(map, exludedSignParams, key);
    }

    public static boolean checkIsSignValidFromResponseString(String responseString, Set<String> exludedSignParams, String key) throws DocumentException {
        Map<String, String> map = LeshuaSignature.getMapFromXML(responseString);
        String signFromAPIResponse = map.get("sign");
        if (StringUtils.isEmpty((CharSequence)signFromAPIResponse)) {
            log.error("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728");
            return false;
        }
        log.info("\u670d\u52a1\u5668\u56de\u5305\u91cc\u9762\u7684\u7b7e\u540d\u662f\uff1a{}", (Object)signFromAPIResponse);
        String signForAPIResponse = LeshuaSignature.getMD5Sign(map, exludedSignParams, key);
        if (!signForAPIResponse.equalsIgnoreCase(signFromAPIResponse)) {
            log.error("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0csignForAPIResponse={}\uff0csignFromAPIResponse={}", (Object)signForAPIResponse, (Object)signFromAPIResponse);
            return false;
        }
        return true;
    }

    private static String buildParam4Sign(Map<String, String> paramMap, Set<String> exludedSignParams, String md5Key) {
        Set<String> keySet = paramMap.keySet();
        StringBuilder param = new StringBuilder(20 * keySet.size());
        Object[] keys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            String value;
            if (exludedSignParams != null && exludedSignParams.contains(key) || (value = paramMap.get(key)) == null) continue;
            param.append((String)key).append("=").append((Object)value).append("&");
        }
        param.append(SECRET_KEY).append("=").append(md5Key);
        return param.toString();
    }

    private static String generateMd5SignStr(Map<String, Object> paramMap, Set<String> exludedSignParams, String md5Key) {
        Set<String> keySet = paramMap.keySet();
        StringBuilder param = new StringBuilder(20 * keySet.size());
        Object[] keys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            Object value;
            if (exludedSignParams != null && exludedSignParams.contains(key) || (value = paramMap.get(key)) == null) continue;
            param.append((String)key).append("=").append(value).append("&");
        }
        param.append(SECRET_KEY).append("=").append(md5Key);
        return param.toString();
    }

    public static Map<String, String> getMapFromXML(String xmlString) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xmlString);
        Element root = document.getRootElement();
        List eleList = root.elements();
        if (eleList != null) {
            HashMap<String, String> map = new HashMap<String, String>(eleList.size());
            for (Object obj : eleList) {
                if (!(obj instanceof Element)) {
                    log.warn("\u8282\u70b9[{}]\u4e0d\u662fElement\uff0c\u5ffd\u7565\uff01", obj);
                    continue;
                }
                Element ele = (Element)obj;
                map.put(ele.getName(), ele.getText());
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public static String getBase64Sign(String agentKey, JSONObject data) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("lepos").append(agentKey).append(data);
        return Base64.encodeBase64String((byte[])DigestUtils.md5Hex((String)sb.toString()).getBytes("utf-8"));
    }

    public static String getRiskBase64Sign(String agentKey, String data) throws LeshuaException {
        StringBuilder sb = new StringBuilder();
        sb.append("lepos").append(agentKey).append(data);
        try {
            return Base64.encodeBase64String((byte[])DigestUtils.md5Hex((String)sb.toString()).toLowerCase().getBytes("utf-8"));
        }
        catch (Exception e) {
            throw new LeshuaException("\u7b7e\u540d\u83b7\u53d6\u5931\u8d25", e);
        }
    }

    public static Set<String> reqExcludedSignParams() {
        HashSet<String> excludedSignParams = new HashSet<String>(1);
        excludedSignParams.add("sign");
        return excludedSignParams;
    }

    public static Set<String> resExcludedSignParams() {
        HashSet<String> excludedSignParams = new HashSet<String>(2);
        excludedSignParams.add("sign");
        excludedSignParams.add("resp_code");
        return excludedSignParams;
    }

    public static Set<String> notifyExcludedSignParams() {
        HashSet<String> excludedSignParams = new HashSet<String>(2);
        excludedSignParams.add("sign");
        excludedSignParams.add("error_code");
        return excludedSignParams;
    }
}

