/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaBasicClient;
import com.fshows.leshuapay.sdk.request.basic.BankBranchRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.response.basic.BankBranch;
import com.fshows.leshuapay.sdk.response.basic.BankBranchListResponse;
import com.fshows.leshuapay.sdk.util.FsHttpUtil;
import com.fshows.leshuapay.sdk.util.ReqSerialNoUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaBasicClientImpl<Req, Res>
implements LeshuaBasicClient<Req, Res> {
    private static final Logger log = LoggerFactory.getLogger(LeshuaBasicClientImpl.class);
    private String serverUrl;
    private String agentId;

    public LeshuaBasicClientImpl(String serverUrl, String agentId) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
    }

    @Override
    public LeshuaBaseResponse<List<Res>> execute(Req request, Class<Res> resClass, String url) {
        LeshuaBaseResponse<List<Res>> response = new LeshuaBaseResponse<List<Res>>();
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        ConcurrentSkipListMap<String, String> requestMap = new ConcurrentSkipListMap<String, String>();
        requestMap.put("agentId", this.agentId);
        requestMap.put("reqSerialNo", reqSerialNo);
        requestMap.put("data", JSON.toJSONString(request));
        try {
            String responseStr = FsHttpUtil.post(this.serverUrl + url, requestMap);
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            response.setRespCode(jsonObject.getString("respCode"));
            response.setRespMsg(jsonObject.getString("respMsg"));
            response.setVersion(jsonObject.getString("version"));
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            List resList = jsonArray.toJavaList(resClass);
            response.setData(resList);
            return response;
        }
        catch (IOException e) {
            log.error("\u6267\u884chttp\u8bf7\u6c42\u5f02\u5e38,e={}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return response;
        }
    }

    @Override
    public LeshuaBaseResponse<BankBranchListResponse> queryBankBranch(BankBranchRequest request, String url) {
        LeshuaBaseResponse<BankBranchListResponse> response = new LeshuaBaseResponse<BankBranchListResponse>();
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        ConcurrentSkipListMap<String, String> requestMap = new ConcurrentSkipListMap<String, String>();
        requestMap.put("agentId", this.agentId);
        requestMap.put("reqSerialNo", reqSerialNo);
        requestMap.put("data", JSON.toJSONString((Object)request));
        try {
            String responseStr = FsHttpUtil.post(this.serverUrl + url, requestMap);
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            response.setRespCode(jsonObject.getString("respCode"));
            response.setRespMsg(jsonObject.getString("respMsg"));
            response.setVersion(jsonObject.getString("version"));
            JSONObject dataJson = jsonObject.getJSONObject("data");
            BankBranchListResponse bankBranchListResponse = new BankBranchListResponse();
            bankBranchListResponse.setTotal(dataJson.getInteger("total"));
            JSONArray jsonArray = dataJson.getJSONArray("list");
            List bankBranches = jsonArray.toJavaList(BankBranch.class);
            bankBranchListResponse.setList(bankBranches);
            response.setData(bankBranchListResponse);
            return response;
        }
        catch (IOException e) {
            log.error("\u6267\u884chttp\u8bf7\u6c42\u5f02\u5e38,e={}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return response;
        }
    }

    private LeshuaBasicClientImpl() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaBasicClientImpl)) {
            return false;
        }
        LeshuaBasicClientImpl other = (LeshuaBasicClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        return !(this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaBasicClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaBasicClientImpl(serverUrl=" + this.getServerUrl() + ", agentId=" + this.getAgentId() + ")";
    }
}

