/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.BindResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账授权结果查询
 *
 * @author linzy
 * @version BindRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BindRequest extends LeshuaBizRequest<BindResponse> {

    /**
     * 商户号
     * 关联方（其一）的编号，分账出资方
     */
    @NotBlank(message = "merchantId1不能为空")
    private String merchantId1;

    /**
     * 商户号
     * 关联方（另一）的编号，分账接收方
     */
    private String merchantId2;

    /**
     * 说明
     */
    private String remark;

    @Override
    public Class<BindResponse> getResponseClass() {
        return BindResponse.class;
    }
}
