/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 退款查询请求
 * @author xiaotian
 * @version LeshuaRefundQueryRequest.java, v 0.1 2020-07-29 9:28
 */
@Data
public class LeshuaRefundQueryRequest extends LeshuaBasePayRequest{

    /**
     * 接口名
     **/
    private String service = "unified_query_refund";

    /**
     * 乐刷分配商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;


    /**
     * 商户订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷订单号
     */
    private String leshuaOrderId;

    /**
     * 商户退款订单号
     */
    private String 	merchantRefundId;

    /**
     * 乐刷退款订单号
     */
    private String leshuaRefundId;
}

