/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * 其它信息
 *
 * @author zhaoyi
 * @version OtherInfo.java, v 0.1 2020-07-27 15:13 zhaoyi
 */
@Data
public class OtherInfo implements Serializable {

    private static final long serialVersionUID = -5975311178479717264L;
    /**
     * 上报需要的配置信息（只有一个渠道号无需填写此字段）；
     * 特别注意：进件到非线下渠道号商户，进件成功后，请先设置对应通道的费率再进行交易，否则交易费率会按100%结算
     */
    private Integer reportConfigId;

    /**
     * 交易异步回调（通知）地址URL
     */
    private String notifyAddress;

    /**
     * 商户协议照图片地址
     */
    private String agreementPic;

    /**
     * json字符串，其它照片。
     * （传可证明银行卡状态正常的照片，可以是转账成功的截图、商户的银行流水（能展示开户名和卡号）、结算人身份证结算卡摆在一起的照片）
     * 示例"other"
     */
    private String otherPics;

    /**
     * 自动审核
     * true：自动审核
     * false：不自动审核
     * 默认自动审核
     */
    private String autoCheck;
}
