/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Xu Jian
 * @version SearchFeeRateResponse.java, v 0.1 2021-01-27 2:37 下午 xujian
 */
@Data
public class SearchFeeRateResponse implements Serializable {

    private static final long serialVersionUID = 7443578453136567261L;

    /**
     * 费率配置id
     */
    private String id;

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 代理商编号
     */
    private String agentId;

    /**
     * 交易类型
     */
    private Integer transactionType;

    /**
     * 卡类型
     */
    private Integer cardType;

    /**
     * 费率生效时间
     */
    private String startTime;

    /**
     * 费率生效截止时间
     */
    private String endTime;

    /**
     * 交易最小金额
     * <p>
     * 开始金额区间值，整数形式，单位为分。
     */
    private Integer beginAmount;

    /**
     * 交易最大金额
     * <p>
     * 结束金额区间值，整数形式，单位为分。
     */
    private Integer endAmount;

    /**
     * 活动费率值
     */
    private Integer activityFeeRate;

    /**
     * 最低费率金额
     */
    private Integer minRateAmount;

    /**
     * 最大费率金额
     */
    private Integer maxRateAmount;

    /**
     * 是否有效
     */
    private String validateStatus;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 最近修改时间
     */
    private String updateTime;

    /**
     * 备注
     */
    private String remark;

}
