/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Xu Jian
 * @version InvalidActivityRequest.java, v 0.1 2021-01-27 3:03 下午 xujian
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class InvalidActivityRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    /**
     * 乐刷商户编号
     */
    private String merchantId;

    /**
     * 费率配置id
     */
    private String id;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }
}
