/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.ConfigFeeRateResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Xu Jian
 * @version ConfigFeeRateRequest.java, v 0.1 2021-01-27 2:45 下午 xujian
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ConfigFeeRateRequest extends LeshuaBizRequest<ConfigFeeRateResponse> {

    /**
     * 费率配置id
     * <p>
     * 新增时不填。
     * 修改时必填，该参数新增时返回来
     */
    private String id;

    /**
     * 乐刷商户号
     * <p>
     * 新增时必填。
     * 修改是不必填，不可变。
     */
    private String merchantId;

    /**
     * 交易类型
     * <p>
     * 交易类型，1：刷卡，2：微信，3：支付宝，6：银联扫码。
     * 新增时必填。
     * 修改时不必填，不可变。
     */
    private Integer transactionType;

    /**
     * 卡类型
     * <p>
     * 卡类型，0：其他，1：借记卡，2：贷记卡。
     * 修改时不必填，不可变。
     * 新增时，如果是交易类型为银联扫码时必填
     */
    private Integer cardType;

    /**
     * 费率生效时间
     * <p>
     * 新增时必填。
     * 修改时非必填，可变。
     * 最小的时间不可早于1970-01-01 00:00:01
     */
    private String startTime;

    /**
     * 费率生效截止时间
     * <p>
     * 新增时必填。
     * 修改时非必填，可变。
     * 最大的时间点不可超过：2038-01-19 03:14:07
     */
    private String endTime;

    /**
     * 交易最小金额
     * <p>
     * 开始金额区间值，整数形式，单位为分。
     * 新增时必填。
     * 修改时非必填，可变。
     */
    private Integer beginAmount;

    /**
     * 交易最大金额
     * <p>
     * 结束金额区间值，整数形式，单位为分。
     * 新增时必填。
     * 修改时非必填，可变。
     */
    private Integer endAmount;

    /**
     * 活动费率值
     * <p>
     * 活动费率值，单位为十万分位，整数形式，兼容设置费率值为0.001%
     * 新增时必填。
     * 修改时非必填，可变。
     */
    private Integer activityFeeRate;

    /**
     * 最低费率金额
     * <p>
     * 最低费率金额，最低费率值，整数形式，单位为分。
     * 新增时非必填，不填默认为0。
     * 修改时非必填，可变。
     */
    private Integer minRateAmount;

    /**
     * 最大费率金额
     * <p>
     * 最大费率金额，最低费率值，整数形式，单位为分。
     * 新增时非必填，不填默认无上限。
     * 修改时非必填，可变。
     */
    private Integer maxRateAmount;


    @Override
    public Class<ConfigFeeRateResponse> getResponseClass() {
        return ConfigFeeRateResponse.class;
    }
}
