/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.trade.order.LakalaQueryRateFeeResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 交易手续费查询接口
 *
 * @author liluqing
 * @version LakalaQueryRateFeeRequest.java, v 0.1 2022-03-09 10:47
 */
@Data
public class LakalaQueryRateFeeRequest extends LakalaBizRequest<LakalaQueryRateFeeResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = -993044581755142288L;

    /**
     * 商户号 (必填参数)
     * 示例：822162070110095
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 示例：B0097326
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 流水号 (必填参数)
     * 示例：66210001790062
     */
    @NotBlank
    @Length(max = 32, message = "流水号长度不能超过32")
    private String logNo;

}