/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaChangeSettResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author zhubo
 * @version LakalaChangeSettRequest.java, v 0.1 2023-02-16 16:26 zhubo
 */
@Data
public class LakalaChangeSettRequest extends LakalaBizRequest<LakalaChangeSettResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 3274925187788775366L;

    /**
     * 接口版本号	1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文）
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 商户内部商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户内部商户号长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号
     */
    @NotBlank
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 银联终端号
     */
    @Length(max = 32, message = "银联终端号长度不能超过32")
    private String termNo;

    /**
     * 结算账户开户行号
     */
    @Length(max = 32, message = "结算账户开户行号长度不能超过32")
    private String openningBankCode;

    /**
     * 结算账户开户行名称
     */
    @Length(max = 32, message = "结算账户开户行名称长度不能超过32")
    private String openningBankName;

    /**
     * 结算账户清算行号
     */
    @NotBlank
    @Length(max = 32, message = "结算账户清算行号长度不能超过32")
    private String clearingBankCode;

    /**
     * 结算账户账号
     */
    @Length(max = 32, message = "结算账户账号长度不能超过32")
    private String acctNo;

    /**
     * 结算账户名称
     */
    @Length(max = 64, message = "结算账户名称长度不能超过64")
    private String acctName;

    /**
     * 结算人证件类型 57 对公 ;58 对私
     */
    @Length(max = 8, message = "结算人证件类型长度不能超过8")
    private String acctTypeCode;

    /**
     * 结算周期
     */
    @Length(max = 8, message = "结算周期长度不能超过8")
    private String settlePeriod;

    /**
     * 日切时间
     */
    @Length(max = 16, message = "日切时间长度不能超过16")
    private String clearDt;

    /**
     * 结算人证件类型
     */
    @Length(max = 8, message = "结算人证件类型长度不能超过8")
    private String acctIdType;

    /**
     * 结算账户证件号码
     */
    @Length(max = 32, message = "结算账户证件号码长度不能超过32")
    private String acctIdcard;

    /**
     * 结算人证件有效期
     */
    @Length(max = 32, message = "结算人证件有效期长度不能超过32")
    private String acctIdDt;

    /**
     * 附件信息集合
     */
    private List<LakalaFileDataRequest> fileDataSet;

    /**
     * 回调地址
     */
    @NotBlank
    @Length(max = 64, message = "回调地址长度不能超过64")
    private String retUrl;
}
