package com.fshows.lakala.enums.merchant;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.common.UploadPictureRequest;
import com.fshows.lakala.request.merchant.*;
import com.fshows.lakala.response.common.UploadPictureReponse;
import com.fshows.lakala.response.merchant.*;

/**
 * 拉卡拉商户进件入驻相关API
 *
 * @author liluqing
 * @version LakalaMerchantApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaMerchantApiDefinitionEnum implements ILakalaApiDefinition {
    ADD_MERCHANT(
            "商户入驻接口",
            "api/v2/mms/openApi/addMer",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaAddMerchantRequest.class,
            LakalaAddMerchantResponse.class
    ),
    ADD_TERM(
            "增网增终进件",
            "api/v2/mms/openApi/addTerm",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaAddTermRequest.class,
            LakalaAddTermResponse.class
    ),
    CHANGE_MERCHANT(
            "商户信息变更",
            "api/v2/mms/openApi/changeMer",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaChangeMerchantRequest.class,
            LakalaChangeMerchantResponse.class
    ),
    QUERY_MERCHANT_INCOME(
            "商户进件查询",
            "api/v2/mms/openApi/queryContract",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaQueryContractRequest.class,
            LakalaQueryContractResponse.class
    ),
    WX_CONFIG(
            "微信参数配置",
            "api/v2/mms/openApi/wechatParamConf",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaWechatConfigRequest.class,
            LakalaWechatConfigResponse.class
    ),
    CHANGE_BANK_CARD(
            "商户换绑卡",
            "api/v2/mms/openApi/changeSett",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaChangeSettRequest.class,
            LakalaChangeSettResponse.class
    ),
    CHANGE_RATE(
            "费率信息变更",
            "api/v2/mms/openApi/changeFee",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaRateChangeFeeRequest.class,
            LakalaRateChangeFeeResponse.class
    ),
    QUERY_MERCHANT_INFO(
            "商户信息查询",
            "api/v2/mms/openApi/queryMerchant",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaQueryMerchantRequest.class,
            LakalaQueryMerchantResponse.class
    ),
    QUERY_SUB_MERHCNAT_INFO(
            "商户报备信息查询",
            "api/v2/mms/openApi/querySubMerInfo",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaQuerySubMerchantRequest.class,
            LakalaQuerySubMerchantResponse.class
    ),
    UPLOAD_FILE(
            "文件上传",
            "api/v2/mms/openApi/uploadFile",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            UploadPictureRequest.class,
            UploadPictureReponse.class
    ),
    WECHAT_REAL_NAME_QUERY(
            "微信实名认证结果查询",
            "mms/openApi/wechatRealNameQuery",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaWechatRealNameQueryRequest.class,
            LakalaWechatRealNameQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaMerchantApiDefinitionEnum(String name,
                                    String apiSubURI,
                                    String version,
                                    Class requestClass,
                                    Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}