package com.fshows.kqbill.util;

import com.alibaba.fastjson.JSONObject;
import com.bill99.crypto.entity.Bill99CertConfig;
import com.bill99.crypto.service.CryptoService;
import com.bill99.crypto.service.processor.P7CryptoServiceProcessor;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;

public class SignUtil {
    private static CryptoService cryptoService = P7CryptoServiceProcessor.getInstance();

    public SignUtil(DefaultClientConfigModel configModel) {
        // 证书配置
        Bill99CertConfig config = new Bill99CertConfig();
        config.setBill99DefaultPublicPath(configModel.getPayCompanyPublicKey());
        config.setMerchantDefaultPrivatePath(configModel.getFubeiPrivateKey());
        config.setMerchantDefaultPrivatePassword(configModel.getPassword());
        cryptoService.setBill99CertConfig(config);
    }

    public JSONObject encrypt(String reqData) throws Exception {
        //调用加密方法
        return cryptoService.seal(reqData);
    }

    public String decrypt(JSONObject respEncryptBody) throws Exception {
        String respSignedData = respEncryptBody.getString("signedData");
        String respEnvelopedData = respEncryptBody.getString("envelopedData");
        return cryptoService.unSeal(respEnvelopedData, respSignedData);
    }

    public static void main(String[] args) throws Exception {
        String signedData = "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";
        String envelopedData = "MIAGCSqGSIb3DQEHA6CAMIACAQAxggGAMIIBfAIBADBkMFgxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxFzAVBgNVBAMMDkNGQ0EgQUNTIE9DQTMzAggzAAAEhiM0EDANBgkqhkiG9w0BAQEFAASCAQBpEKrL3hXVXb7adKh36l45yG+EE4m9Rv50PzVahov84GG7Cx64E3CTiENv3PF0KvvWJ+xHRIa4FnifSRLdEIH85ZTo0J+bABhswCIDfQ81FdiPmZbvsd/uOP+4cwAmB4TMhD4b5OgsfEW/9zPcMMCpLsuUs56UDqZm2gNVNUNZ54/xsE8Wx86a9QpAFWyYIS71nizGTNldiLHxtGsnaE9foYwdNEG2lYWVlvC2k/N7EmUBAMK3eUqd17+vCL9pzWAjNmcbg/msFNt8BCjSgiK0RgpN6chPG3Zcoj3AgHn07CpVYenmhYaBnit5sYV9X/YSSCJEj4U51FuCY0TuL01QMIAGCSqGSIb3DQEHATAdBglghkgBZQMEAQIEEAAAAAAAAAAAAAAAAAAAAACggASCAwCjb9xosHoaN7NuhaSa3VMK/xZ8PoXQRvP4G6M0X26297KoRVDV/cUNqwYioBjh+YG2luKRXrS8uCGGl5YuWpkxm6cpmb6cTqS73JWYQdDGClq/Jd/WPVV4zos8j7VE2FhKScnsUqFytLtLpVfUY866iJHxOawguu9Jorj42UH6SJ9+P/4iUTHZ1WoWdg7R7QavpX+kp1bQSOUNaURk7McipHDYzU/B7q6Zt+lNk14pkjBC2tD+Aly0h27bOc6yCNkWw4oypiVwEYSmP8BgM2S+y5krK64tksxhDPfS+yk3I1JbNiDGFcgzvkzJvVptf8O8JtS07sOOSchDkqXaaytKI205JykGAS/tPCzBn/nXx5eWeKCCIChCG/mRrDSZuFxX7EA8EumHRKO8UdWSC4DdKXWX6hksFZJVA0mxt3itPg8p/zaOTD89J0Ayzs96O1iONxqCTpckcCofuwzIeBKwuZuWmKCAx23+CBpMutKUdou7KyT1BD/1VG59E0sUvJIIpPCs6xfl/qZRX0bw2rjFG47KezG40z5mAiU3+hyl3QiBmWt45vYK8blBqijc6F2Xq4a+IyU3/dUlqY+lBkwQXRSSGFQ1+cc4fSWs7jaTWAtQADzt9X8UuQA/b/bpNatQaFmq373wbAMnMklvT0sdyas+ikTCEjqjpbt1FS6SEI0Df80xVw170rXfyHR1hkgfnhjAI4M31Zr47v6EAGIFkekYHKFvilw3JEaMKoBHHSiiN/G8+H2QbCTbDxMW7CrZ4EHnFTeNAlt8ihqpuFhAJjjsT8l+mIn0nmmtUMitfKFFlOqWxezHnHmcadiQIW5nXy88oZUaCebaWJW9gTOn6gUvcSxrYQw1NjCxZdTkK3NTUMJPWlRS9THyQbVTxtfFd6I6FRI3H24JDECz6RSRmGhjx+RsZIqBniVb26iZ3d/doQgJlTW+o+PZRd++qNTRDHaHCVEXYSCJ0vO0Nz6sQywytXad4Jtt1J+vCfAMaQhzPLfE8bY+eQrFHBqyFiMAAAAAAAAAAAAA";

        DefaultClientConfigModel configModel = new DefaultClientConfigModel();
        configModel.setFubeiPrivateKey("C:\\Users\\liluqing\\Desktop\\TP_EX_964219_20240804\\kqbill_private.pfx");
        configModel.setPayCompanyPublicKey("C:\\Users\\liluqing\\Desktop\\TP_EX_964219_20240804\\kqbill_public.cer");
        configModel.setPassword("123456");

        FsCryptoServiceUril signUtil = new FsCryptoServiceUril(configModel);
//        Bill99CertConfig config = new Bill99CertConfig();
//        config.setBill99DefaultPublicPath(configModel.getPayCompanyPublicKey());
//        config.setMerchantDefaultPrivatePath(configModel.getFubeiPrivateKey());
//        config.setMerchantDefaultPrivatePassword(configModel.getPassword());
//        signUtil.setBill99CertConfig(config);


        System.out.println(signUtil.unSeal(envelopedData,signedData));

//        InputStream keystoreFileInputStream = FileLoader.getCertFileStream("C:\\Users\\liluqing\\Desktop\\TP_EX_964219_20240804\\kqbill_ssl.pfx");
//
//        KeyStore keyStore = KeyStore.getInstance("PKCS12");
//        keyStore.load(keystoreFileInputStream, "vpos123".toCharArray());
//
//        HttpClientCert httpClientCert = new HttpClientCert();
//        httpClientCert.setKeyStore(keyStore);
//        httpClientCert.setKeyStorePwd("vpos123");
//        httpClientCert.setConnTimeout(10000);
//        httpClientCert.setSoTimeout(10000);
//        httpClientCert.setSSLVersion("TLSv1.2");
//        HttpsClientFactory factory = new HttpsClientFactory();
//        factory.createSSLClient(httpClientCert);
//

//        String str ="{\"amount\":\"1200\",\"cur\":\"CNY\",\"externalRefNumber\":\"20240807012751029178P\",\"merchantId\":\"812440065130392\",\"openId\":\"ozEAf0VG2xLwMS-pNcXw1iiObjbQ\",\"sharingInfo\":{\"feeMode\":1,\"sharingDataList\":[{\"sharingDataAmount\":\"1200\",\"sharingDataContact\":\"WandaParking277\",\"sharingDataContactFlag\":2,\"sharingDataMemo\":\"分账测试\",\"sharingDataSyncFlag\":\"0\"}],\"sharingFlag\":1},\"subAppId\":\"wx457df64656d1d334\",\"terminalId\":\"72059731\",\"terminalIp\":\"112.224.69.156\",\"tr3Url\":\"http://fbtpd.51fubei.com/kqbill/trade/payCallback\",\"txnExpireTime\":300,\"userAgent\":\"01\"}";
//
//        DefaultClientConfigModel configModel = new DefaultClientConfigModel();
//        configModel.setFubeiPrivateKey("C:\\Users\\liluqing\\Desktop\\TP_EX_964219_20240804\\kqbill_private.pfx");
//        configModel.setPayCompanyPublicKey("C:\\Users\\liluqing\\Desktop\\TP_EX_964219_20240804\\kqbill_public.cer");
//        configModel.setPassword("123456");
//
//        FsCryptoServiceUril signUtil = new FsCryptoServiceUril();
//        Bill99CertConfig config = new Bill99CertConfig();
//        config.setBill99DefaultPublicPath(configModel.getPayCompanyPublicKey());
//        config.setMerchantDefaultPrivatePath(configModel.getFubeiPrivateKey());
//        config.setMerchantDefaultPrivatePassword(configModel.getPassword());
//        signUtil.setBill99CertConfig(config);
//
////        SignUtil signUtil = new SignUtil(configModel);
////        String s = signUtil.decrypt(JSONObject.parseObject("{\"signedData\":\"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\",\"envelopedData\":\"MIIDrAYJKoZIhvcNAQcDoIIDnTCCA5kCAQIxggEwMIIBLAIBAoAUuwVbDG59DSaSgqO5Q89+7DuDbfcwDQYJKoZIhvcNAQEBBQAEggEAjZxR7G7ssZFV+5SOi2hLproe+qNi1U6QICxkbwkcH6I8MTjDKJI/OQ2/C8TNrnkDxshXpJyO/LAs8Xz86Z6jAG2wJNWqffC9LMcsTpHeBtS9m0aJpyR2bK0NSfX3MV5M9i/yCSqbs2DmjdS5TWtMEBvzd7tTAQruf/r1XST3ivSwnZbeXVIJxqrHAeT1GZmKYqd8Uc8b+kDtaF9Yyl71SKCO5LWMqOdQfNfDGEuDMyILjH0A6ctSScJ+W99UHpBfZTql26ED89c/MF3hGhYZLrQ823ySoeACgsTqpTJZ9PguLOBGANbMwqjhvjtj8/Gs4+hWwQTzdIkU6mQsKjhhHzCCAl4GCSqGSIb3DQEHATAdBglghkgBZQMEASoEEB/IDPhX4q3LF9oYGB7n+42AggIwRJVEPVYEYTh3dsV4wwBHXoRmd6Dpog67F5bmqGUmdiiTKB5uTTLlwNaNbz+B+eneD+6XG3NZGA+Q2ohoNIm8ugmrNBvkKLvk3125v4uy94V59vIL5muIWjPSgdxrOMd/pqMi4Oet8qzqxkUbFlcErgJvUdi/peekGQ+HComRXiBG+6fgUjRLb7A8gtMoRnt7jKaOoK9dhVkwmtm5i5I3iuSWx6R5oEAVaHvpwWJktKsn3obJ1VR1L3qngTum1TQN771gsgbyNub+daHFgtB24SYyVDs67c7E/FbVkR7mDh+kgXYkBfsWbiLp/5nZ7fBe6Fh5/uppAD6L/KdDTKYUk/JOp8O46HC9BqL97ZaltAEb/Rc9o6vnG2+nk//uQM0brjkw/kuH+Xh4OTp77Hvi/wKRXK6hKUcdx1fxSbdM8jZqHJQmC+8Dm7/zMITA2c9EGhEP07iBabNNSR1BYQD+CgiQ8SL2asrFCCKPCXTgNDZ3SRk8VcsCeGkA5g21ro96ceu0lv0BoLiLkj05DNTsz798vKdaOIZDFCyi/VsnAKSAKMJRbDgCP6fx44zCh2N5q6CXlRnJOtjkaWrYZv34I65fT38Co3x5dzbsYxPG9+/1cxrWwxn/t7Iel3ZPXBSNIEcuYPj3PSMRUHHAVyCu9JNoeDDu4cBpyoTx4bi0pXTDugVowYqgZKgAfSrTAVS5wFHe4u1ZLLqHNW6qBlEDWdhqpf/hInzbGxs41kbZRfw=\"}"));
////        System.out.println(s);
////        System.out.println(signUtil.seal(str));
//
//        List<JSONObject> list = new ArrayList<>();
//
//        long currentTimeMillis = System.currentTimeMillis();
//        int num = 10;
//        for (int i = 0; i < num; i++) {
////            System.out.println();
//            list.add(signUtil.seal(str));
//            System.out.println(signUtil.seal(str));
//        }
//        long time = System.currentTimeMillis()-currentTimeMillis;
//        System.out.println("总耗时："+time);
//        System.out.println("单次耗时：" + time/num);
////
//
//        long currentTimeMillis2 = System.currentTimeMillis();
//
//        for (JSONObject respEncryptBody: list) {
//            String respSignedData = respEncryptBody.getString("signedData");
//            String respEnvelopedData = respEncryptBody.getString("envelopedData");
//            System.out.println(signUtil.unSeal(respEnvelopedData,respSignedData));
//        }
//        long time2 = System.currentTimeMillis()-currentTimeMillis2;
//        System.out.println("总耗时："+time2);
//        System.out.println("单次耗时：" + time2/num);
    }
}
