/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.kqbill.request.trade.detail.RefundSharingInfo;
import com.fshows.kqbill.response.KqbillBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version KqbillOrderReverseRes.java, v 0.1 2024-07-03 5:14 PM wangqilei
 */
@Data
public class KqbillRefundCreateRes extends KqbillBizRes {
    private static final long serialVersionUID = 1659199424305610018L;
    /**
     * 快钱分配给商户的812***商户编号
     * (必填)
     */
    private String merchantId;

    /**
     * 订单的唯一标识
     * (必填)
     */
    private String idOrderCtrl;

    /**
     * 快钱提供的交易控制编号，非必填
     * (选填)
     */
    private String idTxnCtrl;

    /**
     * 快钱提供的交易编号
     * (必填)
     */
    @JSONField(name = "IdTxn")
    private String idTxn;

    /**
     * 交易发生的具体时间，格式：yyyyMMddHHmmss
     * (必填)
     */
    private String entryTime;

    /**
     * 快钱公司分配给商户的8位唯一标识号
     * (必填)
     */
    private String terminalId;

    /**
     * S 交易成功
     * F 交易失败
     * P 交易处理中
     * V 交易撤销
     * R 交易冲正
     * D 已提交收单行（退货可能返回，也表示退货成功）
     * (必填)
     */
    private String txnStatus;

    /**
     * 分账信息
     */
    private RefundSharingInfo refundSharingInfo;
}