/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.kqbill.request.trade.detail.GoodDetail;
import com.fshows.kqbill.response.KqbillBizRes;
import com.fshows.kqbill.response.trade.detail.EquityInfo;
import com.fshows.kqbill.response.trade.detail.PromotionDetail;
import com.fshows.kqbill.response.trade.detail.ThirdPartyDiscountDetail;
import lombok.Data;

import java.util.List;

/**
 * @author wangqilei
 * @version KqbillOrderInfoQueryRes.java, v 0.1 2024-07-03 5:32 PM wangqilei
 */
@Data
public class KqbillOrderInfoQueryRes extends KqbillBizRes {
    private static final long serialVersionUID = 7072236423677999208L;
    /**
     * 快钱分配给商户的812***商户编号
     * (必填)
     */
    private String merchantId;

    /**
     * 订单的唯一标识
     * (必填)
     */
    private String idOrderCtrl;

    /**
     * 快钱提供的交易控制编号，非必填
     * (选填)
     */
    private String idTxnCtrl;

    /**
     * 快钱提供的交易编号
     * (必填)
     */
    @JSONField(name = "IdTxn")
    private String idTxn;

    /**
     * 快钱分配给商户的终端号，必填
     * (必填)
     */
    private String terminalId;

    /**
     * CUP:银联, WECHAT:微信, ALIPAY:支付宝, DCEP:数字人民币, 必填
     * (必填)
     */
    private String channelName;

    /**
     * 交易金额，单位：分，必填
     * (必填)
     */
    private String amount;

    /**
     * 交易发生的具体时间，格式：yyyyMMddHHmmss，必填
     * (必填)
     */
    private String entryTime;

    /**
     * 交易状态（S:成功, F:交易失败, P:处理中, V:撤销, R:冲正, D:已提交收单行），必填
     * (必填)
     */
    private String txnStatus;

    /**
     * 扫码支付/退货/扫码撤销，必填
     * (必填)
     */
    private String txnType;

    /**
     * 交易的流水号，必填
     * (必填)
     */
    private String termTraceNo;

    /**
     * 权益信息，JSON对象字符串，非必填
     * (选填)
     */
    private EquityInfo equityInfo;

    /**
     * 微信或支付宝返回的买家ID，非必填
     * (特殊必填)
     */
    private String thirdPartyBuyerId;

    /**
     * 花呗分期期数，非必填
     * (特殊必填)
     */
    private String installmentNumber;

    /**
     * 花呗手续费比例，暂只支持0、100，0:用户100%承担，100:商家100%承担，非必填
     * (特殊必填)
     */
    private String installmentSellerPercent;

    /**
     * 交易成功后的支付凭证号，必填
     * (必填)
     */
    private String channelTradeNo;

    /**
     * 输入的附加数据，将会原样返回，非必填
     * (特殊必填)
     */
    private String attach;

    /**
     * 优惠活动明细参数
     */
    private List<PromotionDetail> promotionList;

    /**
     * 第三方出资详情
     */
    private List<ThirdPartyDiscountDetail> thirdPartyDiscountList;

    /**
     * 商品优惠信息列表
     */
    private List<GoodDetail> discountGoodsList;

    /**
     * 支付完成时间
     */
    private String timeEnd;
}