/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade.detail;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author wangqilei
 * @version GoodDetail.java, v 0.1 2024-07-03 4:46 PM wangqilei
 */
@Data
public class GoodDetail {
    /**
     * 商户的商品编码，必填
     * (必填)
     */
    @Length(max = 32, message = "isvGoodsId长度不能超过32")
    private String isvGoodsId;

    /**
     * 商品名称，非必填
     * (特殊必填)
     */
    @Length(max = 256, message = "isvGoodsName长度不能超过256")
    private String isvGoodsName;

    /**
     * 商品单价，单位：分，必填（包括商户优惠后的价格）
     * (必填)
     */
    private Integer isvGoodsPrice;

    /**
     * 商品数量，必填
     * (必填)
     */
    private Integer isvGoodsQuantity;

    /**
     * 商品描述，非必填
     * (特殊必填)
     */
    @Length(max = 100, message = "isvGoodsDesc长度不能超过100")
    private String isvGoodsDesc;

    /**
     * 商品分类，格式：门店-商品分类，必填
     * (必填)
     */
    @Length(max = 24, message = "isvGoodsCategory长度不能超过24")
    private String isvGoodsCategory;
}