/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade;

import com.fshows.kqbill.request.KqbillBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version KqbillOrderReverseReq.java, v 0.1 2024-07-03 5:11 PM wangqilei
 */
@Data
public class KqbillOrderInfoQueryReq extends KqbillBizReq {
    /**
     * 商户在快钱的唯一标识
     */
    @NotBlank
    @Length(max = 15, message = "merchantId长度不能超过15")
    private String merchantId;

    /**
     * 快钱分配给商户的终端编号
     * (必填)
     */
    @Length(max = 15, message = "terminalId长度不能超过15")
    private String terminalId;

    /**
     * 原订单控制编号，原支付交易返回的订单控制编号，超时撤销可以不传，其他情况必须传
     */
    @Length(max = 20, message = "origOrderCtrl长度不能超过20")
    private String origOrderCtrl;
}