/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request;

import lombok.Data;

/**
 * @author wangqilei
 * @version KqbillHeaderReq.java, v 0.1 2024-07-04 11:16 AM wangqilei
 */
@Data
public class KqbillHeaderReq {
    /**
     * 接口版本号，标识当前消息，默认值为1.0.0
     * (必填)
     */
    private String version;

    /**
     * 区分报文功能，每种报文类型不同，例如A7009代表统一后台下单
     * (必填)
     */
    private String messageType;

    /**
     * 快钱公司分配给商户的11位账户号
     * (必填)
     */
    private String memberCode;

    /**
     * 快钱公司分配给商户的11位账户号
     * (必填)
     */
    private String vendorMemberCode;

    /**
     * 商户提供的该笔预下单交易的商户订单号，商户需保证每笔交易订单号唯一
     * (必填)
     */
    private String externalRefNumber;
}