/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.kqbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.kqbill.apienum.KqbillTradeApiEnum;
import com.fshows.kqbill.handler.KqbillClientConfigModel;
import com.fshows.kqbill.handler.NewKqbillPostWithSSLRequestHandler;
import com.fshows.kqbill.request.KqbillBizReq;
import com.fshows.kqbill.request.KqbillHeaderReq;
import com.fshows.kqbill.response.KqbillBizRes;
import com.fshows.kqbill.util.FsCryptoServiceUril;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KqbillTradeApiClient
extends AbstractApiClient<KqbillBizReq, KqbillBizRes, KqbillTradeApiEnum> {
    private static final Logger log = LoggerFactory.getLogger(KqbillTradeApiClient.class);
    private KqbillClientConfigModel kqbillClientConfig;
    private FsCryptoServiceUril signUtil;
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler;

    public KqbillTradeApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        this.kqbillClientConfig = (KqbillClientConfigModel)apiClientConfig;
        this.httpRequestHandler = new NewKqbillPostWithSSLRequestHandler(apiClientConfig);
        try {
            this.signUtil = new FsCryptoServiceUril(apiClientConfig);
        }
        catch (Exception e) {
            log.error("KqbillTradeApiClient >> \u5feb\u94b1\u52a0\u89e3\u5bc6\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5f02\u5e38 \uff01", (Throwable)e);
            throw new FsApiException("\u5feb\u94b1\u52a0\u89e3\u5bc6\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5f02\u5e38");
        }
    }

    protected KqbillBizRes doExecute(KqbillBizReq request, KqbillTradeApiEnum iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            LogUtil.debug((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f00\u59cb[\u5bc6\u6587] >> url={}, method={}, request={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, apiRequestModel.getRequestBody(), System.currentTimeMillis() - beginTime});
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.debug((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime});
            KqbillBizRes result = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)result), System.currentTimeMillis() - beginTime});
            return result;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected ApiRequestModel buildApiRequestModel(KqbillBizReq request, DefaultRequestContext context) {
        String requestBody = "";
        try {
            ApiRequestModel apiRequestModel = new ApiRequestModel();
            apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL());
            KqbillHeaderReq headerReq = new KqbillHeaderReq();
            headerReq.setVersion(context.getIApiDefinition().getVersion());
            headerReq.setMemberCode(context.getApiClientConfig().getAppId());
            headerReq.setMessageType(context.getIApiDefinition().getApiURI());
            headerReq.setExternalRefNumber(request.getExternalRefNumber());
            JSONObject encryptBody = this.signUtil.encrypt(JSON.toJSONString((Object)request));
            JSONObject requestString = new JSONObject();
            requestString.put("head", (Object)headerReq);
            requestString.put("requestBody", (Object)encryptBody);
            apiRequestModel.setRequestBody(requestString.toJSONString());
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Accept-Encoding", "identity");
            apiRequestModel.setHeadMap(headMap);
            return apiRequestModel;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5feb\u94b1\u652f\u4ed8\u5f02\u5e38 >> iApiDefinition={}, request={}, requestBody={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), context.getIApiDefinition(), request, requestBody});
            throw new RuntimeException(e);
        }
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("kqbill-sdk");
        clientInfoModel.setClientName("\u5feb\u94b1\u652f\u4ed8");
        return clientInfoModel;
    }

    protected KqbillBizRes buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject dataJson = null;
        try {
            dataJson = JSONObject.parseObject((String)apiResponseModel.getResponseBody());
            KqbillBizRes bizRes = new KqbillBizRes();
            JSONObject resBody = dataJson.getJSONObject("responseBody");
            if (resBody != null && resBody.size() > 0) {
                String decrptBody = this.signUtil.decrypt(resBody);
                bizRes = (KqbillBizRes)JSONObject.parseObject((String)decrptBody, (Class)requestContext.getIApiDefinition().getResponseClass());
            }
            KqbillBizRes.KqbillHeaderRes headerRes = (KqbillBizRes.KqbillHeaderRes)JSONObject.parseObject((String)dataJson.getString("head"), KqbillBizRes.KqbillHeaderRes.class);
            bizRes.setHead(headerRes);
            return bizRes;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u5feb\u94b1\u652f\u4ed8\u54cd\u5e94\u5f02\u5e38 >> iApiDefinition={}, request={}, \u4e1a\u52a1\u54cd\u5e94\u62a5\u6587dataJson={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), requestContext.getIApiDefinition(), apiRequestModel.getRequest(), dataJson});
            throw new RuntimeException(e);
        }
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    public KqbillBizRes execute(KqbillBizReq request, KqbillTradeApiEnum apiDefinition) throws FsApiException {
        return (KqbillBizRes)this.doExecute(request, apiDefinition);
    }

    public KqbillBizRes execute(KqbillBizReq request, KqbillTradeApiEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected DefaultRequestContext buildRequestContext(KqbillTradeApiEnum tradeApiDefinitionEnum, KqbillBizReq request, DefaultClientConfigModel merchantConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        KqbillClientConfigModel clientConfig = this.kqbillClientConfig;
        KqbillClientConfigModel config = this.copyKqbillConfig(clientConfig);
        if (merchantConfig != null) {
            config.setAgentId(StringUtils.isEmpty((CharSequence)merchantConfig.getAgentId()) ? clientConfig.getAgentId() : merchantConfig.getAgentId());
            config.setAppId(StringUtils.isEmpty((CharSequence)merchantConfig.getAppId()) ? clientConfig.getAppId() : merchantConfig.getAppId());
            config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)merchantConfig.getFubeiPrivateKey()) ? clientConfig.getFubeiPrivateKey() : merchantConfig.getFubeiPrivateKey());
            config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)merchantConfig.getPayCompanyPublicKey()) ? clientConfig.getPayCompanyPublicKey() : merchantConfig.getPayCompanyPublicKey());
        }
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    private KqbillClientConfigModel copyKqbillConfig(KqbillClientConfigModel clientConfigModel) {
        KqbillClientConfigModel configModel = new KqbillClientConfigModel();
        configModel.setAppId(clientConfigModel.getAppId());
        configModel.setAgentId(clientConfigModel.getAgentId());
        configModel.setFubeiPrivateKey(clientConfigModel.getFubeiPrivateKey());
        configModel.setPayCompanyPublicKey(clientConfigModel.getPayCompanyPublicKey());
        configModel.setPassword(clientConfigModel.getPassword());
        configModel.setApiParentURL(clientConfigModel.getApiParentURL());
        configModel.setMd5SignKey(clientConfigModel.getMd5SignKey());
        configModel.setSignTypeEnum(clientConfigModel.getSignTypeEnum());
        configModel.setVrifySignResponse(clientConfigModel.isVrifySignResponse());
        configModel.setCheckParam(clientConfigModel.isCheckParam());
        configModel.setConnectionTimeout(clientConfigModel.getConnectionTimeout());
        configModel.setReadTimeout(clientConfigModel.getReadTimeout());
        configModel.setCharset(clientConfigModel.getCharset());
        configModel.setHump(clientConfigModel.isHump());
        configModel.setExtendParam(new HashMap(clientConfigModel.getExtendParam()));
        configModel.setSingIgnoreNull(clientConfigModel.isSingIgnoreNull());
        configModel.setSSLVersion(clientConfigModel.getSSLVersion());
        configModel.setSSLCertPath(clientConfigModel.getSSLCertPath());
        configModel.setSSLKeyStore(clientConfigModel.getSSLKeyStore());
        configModel.setSSLKeyPass(clientConfigModel.getSSLKeyPass());
        configModel.setKeyStore(clientConfigModel.getKeyStore());
        return configModel;
    }

    public JSONObject encodeStr(String data) throws Exception {
        return this.signUtil.encrypt(data);
    }

    public String decodeStr(JSONObject data) throws Exception {
        return this.signUtil.decrypt(data);
    }
}

