/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.kqbill.util;

import com.alibaba.fastjson.JSONObject;
import com.bill99.crypto.config.CryptoConfig;
import com.bill99.crypto.entity.Bill99CertConfig;
import com.bill99.crypto.processor.P7CryptoProcessor;
import com.bill99.crypto.utils.Bill99CertLoader;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;

/**
 *
 * @author liluqing
 * @version FsCryptoServiceUril.java, v 0.1 2024-08-07 1:33
 */
public class FsCryptoServiceUril {
    private Bill99CertConfig bill99CertConfig;
    P7CryptoProcessor processor = null;

    public FsCryptoServiceUril(DefaultClientConfigModel configModel) throws Exception {
        // 证书配置
        Bill99CertConfig config = new Bill99CertConfig();
        config.setBill99DefaultPublicPath(configModel.getPayCompanyPublicKey());
        config.setMerchantDefaultPrivatePath(configModel.getFubeiPrivateKey());
        config.setMerchantDefaultPrivatePassword(configModel.getPassword());
        setBill99CertConfig(config);
    }


    public void setBill99CertConfig(Bill99CertConfig bill99CertConfig) throws Exception {
        this.bill99CertConfig = bill99CertConfig;
        processor = new P7CryptoProcessor();
        CryptoConfig cryptoConfig = Bill99CertLoader.loadCryptoConfig(this.bill99CertConfig);
        processor.setCryptoConfig(cryptoConfig);
    }

    public JSONObject seal(String originalData) throws Exception {
        JSONObject requestBody = new JSONObject();
        requestBody.put("signedData", processor.p7Sign(originalData));
        requestBody.put("envelopedData", processor.p7Envelop(originalData));
        return requestBody;
    }

    public String unSeal(String envelopedData, String signedData) throws Exception {
        String originalData = processor.p7OpenEnvelope(envelopedData);
        boolean result = processor.p7Verify(originalData, signedData);
        return result ? originalData : null;
    }

    public JSONObject encrypt(String reqData) throws Exception {
        //调用加密方法
        return seal(reqData);
    }

    public String decrypt(JSONObject respEncryptBody) throws Exception {
        String respSignedData = respEncryptBody.getString("signedData");
        String respEnvelopedData = respEncryptBody.getString("envelopedData");
        return unSeal(respEnvelopedData, respSignedData);
    }
}