/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.kqbill.response.KqbillBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version KqbillOrderPayRes.java, v 0.1 2024-06-05 3:55 PM wangqilei
 */
@Data
public class KqbillOrderStatusQueryRes extends KqbillBizRes {
    private static final long serialVersionUID = -8880687432977995532L;

    /**
     * 快钱分配给商户的812***商户编号
     * (必填)
     */
    private String merchantId;

    /**
     * 订单的唯一标识
     * (必填)
     */
    private String idOrderCtrl;

    /**
     * 快钱提供的交易控制编号，非必填
     * (选填)
     */
    private String idTxnCtrl;

    /**
     * 交易的流水号，非必填，快钱生成并返回
     * (选填)
     */
    private String termTraceNo;

    /**
     * 快钱提供的交易编号
     * (必填)
     */
    @JSONField(name = "IdTxn")
    private String idTxn;

    /**
     * 交易发生的具体时间，格式：yyyyMMddHHmmss
     * (必填)
     */
    private String entryTime;

    /**
     * CUP：银联, WECHAT：微信, ALIPAY：支付宝, DCEP:数字人民币
     * (必填)
     */
    private String channelName;

    /**
     * P-处理中, S-交易成功, F-交易失败
     * (必填)
     */
    private String txnStatus;

    /**
     * 订单的支付金额，单位：分，原值返回
     * (必填)
     */
    private String amount;
}