/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade.detail;

import lombok.Data;

/**
 * @author wangqilei
 * @version SharingDataList.java, v 0.1 2024-07-03 4:41 PM wangqilei
 */
@Data
public class SharingData {
    /**
     * 固定值2，表示useId（平台合作商户在平台的唯一标识）
     * (必填)
     */
    private Integer sharingDataContactFlag;

    /**
     * 分账方useId
     * (必填)
     */
    private String sharingDataContact;

    /**
     * 分账金额，单位为分，大于0
     * (必填)
     */
    private String sharingDataAmount;

    /**
     * 分账模式，固定值0、1或T+N（1<=N<=99），0:准同步，1:异步，T+N:按计划分账
     * (特殊必填)
     */
    private String sharingDataSyncFlag;

    /**
     * 可为空，备注字段
     * (选填)
     */
    private String sharingDataMemo;
}