/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.handler;

import com.bill99.crypto.utils.FileLoader;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;

/**
 * @author wangqilei
 * @version KqbillPostHttpWithSSLRequestHandler.java, v 0.1 2024-07-04 9:17 AM wangqilei
 */
public class KqbillPostHttpWithSSLRequestHandler implements IHttpRequestHandler {
    private static final int SO_TIMEOUT = 60 * 1000;
    private static final int CONN_TIMEOUT = 10 * 1000;
    private CloseableHttpClient httpClient;

    public KqbillPostHttpWithSSLRequestHandler(DefaultClientConfigModel configModel) {
        if (configModel.getApiParentURL().startsWith("https")) {
            try {
                httpClient = this.createHttpsClient(configModel);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            // 兼容没有开启SSL认证
            httpClient = HttpClients.createDefault();
        }
    }

    @Override
    public ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        HttpPost httpPost = new HttpPost(apiRequestModel.getApiURL());
//        if (apiRequestModel.getApiURL().startsWith("https")) {
//            try {
//                httpClient = this.createHttpsClient(requestContext.getApiClientConfig());
//            } catch (Exception e) {
//                throw new RuntimeException(e);
//            }
//        } else {
//            // 兼容没有开启SSL认证
//            httpClient = HttpClients.createDefault();
//        }
        RequestConfig requestConfig = RequestConfig.custom()
                .setSocketTimeout(SO_TIMEOUT)
                .setConnectTimeout(CONN_TIMEOUT).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(new StringEntity(apiRequestModel.getRequestBody(), Consts.UTF_8));

        String resp = httpClient.execute(httpPost, httpresponse -> {
            HttpEntity entity = httpresponse.getEntity();
            if (entity != null) {
                return EntityUtils.toString(entity, Consts.UTF_8);
            }
            return null;
        });

        // 封装请求结果
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(resp);
        return responseModel;
    }

    private CloseableHttpClient createHttpsClient(DefaultClientConfigModel model) throws Exception {
        KqbillClientConfigModel configModel = (KqbillClientConfigModel) model;
//        InputStream keystoreFileInputStream = FileLoader.getCertFileStream(configModel.getSSLCertPath());
//        KeyStore keyStore = KeyStore.getInstance(configModel.getSSLKeyStore());
        try {
//            keyStore.load(keystoreFileInputStream, configModel.getSSLKeyPass().toCharArray());
            HttpClientCert httpClientCert = new HttpClientCert();
            httpClientCert.setKeyStore(configModel.getKeyStore());
            httpClientCert.setKeyStorePwd(configModel.getSSLKeyPass());
            httpClientCert.setConnTimeout(CONN_TIMEOUT);
            httpClientCert.setSoTimeout(SO_TIMEOUT);
            httpClientCert.setSSLVersion(configModel.getSSLVersion());

            HttpsClientFactory factory = new HttpsClientFactory();
            return factory.createSSLClient(httpClientCert);
        } catch (Exception e) {
            throw e;
//        } finally {
//            if (keystoreFileInputStream != null) {
//                keystoreFileInputStream.close();
//            }
        }
    }
}