/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.kqbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.kqbill.apienum.KqbillTradeApiEnum;
import com.fshows.kqbill.handler.KqbillClientConfigModel;
import com.fshows.kqbill.handler.NewKqbillPostWithSSLRequestHandler;
import com.fshows.kqbill.request.KqbillBizReq;
import com.fshows.kqbill.request.KqbillHeaderReq;
import com.fshows.kqbill.response.KqbillBizRes;
import com.fshows.kqbill.util.FsCryptoServiceUril;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KqbillTradeApiClient
extends AbstractApiClient<KqbillBizReq, KqbillBizRes, KqbillTradeApiEnum> {
    private static final Logger log = LoggerFactory.getLogger(KqbillTradeApiClient.class);
    private KqbillClientConfigModel kqbillClientConfig;
    private FsCryptoServiceUril signUtil;
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler;

    public KqbillTradeApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        this.kqbillClientConfig = (KqbillClientConfigModel)apiClientConfig;
        this.httpRequestHandler = new NewKqbillPostWithSSLRequestHandler(apiClientConfig);
        try {
            this.signUtil = new FsCryptoServiceUril(apiClientConfig);
        }
        catch (Exception e) {
            log.error("KqbillTradeApiClient >> \u5feb\u94b1\u52a0\u89e3\u5bc6\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5f02\u5e38 \uff01", (Throwable)e);
            throw new FsApiException("\u5feb\u94b1\u52a0\u89e3\u5bc6\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5f02\u5e38");
        }
    }

    protected KqbillBizRes doExecute(KqbillBizReq request, KqbillTradeApiEnum iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f00\u59cb[\u5bc6\u6587] >> url={}, method={}, request={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, apiRequestModel.getRequestBody(), System.currentTimeMillis() - beginTime});
            apiResponseModel = new ApiResponseModel();
            apiResponseModel.setResponseBody("{\"head\":{\"version\":\"1.0.0\",\"messageType\":\"A7006\",\"memberCode\":\"10222287714\",\"externalRefNumber\":\"172494669971634978\",\"responseCode\":\"0000\",\"responseTextMessage\":\"\u6210\u529f\"},\"responseBody\":{\"signedData\":\"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\",\"envelopedData\":\"MIAGCSqGSIb3DQEHA6CAMIACAQAxggGAMIIBfAIBADBkMFgxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxFzAVBgNVBAMMDkNGQ0EgQUNTIE9DQTMzAggzAAAEhiM0EDANBgkqhkiG9w0BAQEFAASCAQAy4+7Ue0WHwYxoOIOG7bh61TYLwAKYB3Ka7uLWK7kq8ysNuf3Pg/anYp/alXaYHeCddcI5pmpGZjPsAYBlu3oRy0NcZzyEZr7phBJsVlgD4ScbBKqDEv25b9B7eN1JUz+BCaQ7d4Qx5TqIqP18/N8FLyAwDsJ2BH0dvog5U1KeO7g0OSeDLdVip1S/G2XJyYbylxFRXBoj1T8ta30Zw4VEoKFbceDTyGfJUxeOXkkLyvch34egiqjuAQeywPABRfcbSaBtLxcPWEZPActkxzoTwGmuxspxkpNRKO1AVaHnT+D3UqbC4BBwrO26lm3koRL4GlWH+OiLJAat4AG1ySDyMIAGCSqGSIb3DQEHATAdBglghkgBZQMEAQIEEAAAAAAAAAAAAAAAAAAAAACggASCAWDOji7YrtRcifSqtozXMv/q+M1CIhaX5H+pUeLdMfRObNlEBK/aZwq3dM22y+hLGzTJJ8QR3Ogy4zradD0i5SmSc7P3oGDlxJNg3KZRNzmVV7TIXykc25LSX4j8BXC25zsWz/HA76tUw4FFM4Ig1KAnMBxGXn6FOX+WPKqpM2EVUD4JM8I1eL+a3LEYxu8Os1zDV8vkFNbJ8GlMr0Wdww6qf4kpqSXWn5b9381U8JvQKFXei76Oi2sWK5UF8tmWKmVQMpfJ3BEf8PzJCjxWUMDGfI+WcAbjbCvw1kjR9pIM6n+S0/2gPX3jBxo3EaApUBN0n1vsU+UD8DI1kM/8N8GDeWia9ICSntejSiVYTj9963kOqbMjP6N6YMOGMfFRoZ2WqsK2/q6jA+nuWFSwk8VJ0yUnEncTGR2mdHmibTe4HWR62z3a+ndIiAh0HDfBj4rhj6eXbsUhHFpMcziQReFBAAAAAAAAAAAAAA==\"}}");
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime});
            KqbillBizRes result = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)result), System.currentTimeMillis() - beginTime});
            return result;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected ApiRequestModel buildApiRequestModel(KqbillBizReq request, DefaultRequestContext context) {
        String requestBody = "";
        try {
            ApiRequestModel apiRequestModel = new ApiRequestModel();
            apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL());
            KqbillHeaderReq headerReq = new KqbillHeaderReq();
            headerReq.setVersion(context.getIApiDefinition().getVersion());
            headerReq.setMemberCode(context.getApiClientConfig().getAppId());
            headerReq.setMessageType(context.getIApiDefinition().getApiURI());
            headerReq.setExternalRefNumber(request.getExternalRefNumber());
            JSONObject encryptBody = this.signUtil.encrypt(JSON.toJSONString((Object)request));
            JSONObject requestString = new JSONObject();
            requestString.put("head", (Object)headerReq);
            requestString.put("requestBody", (Object)encryptBody);
            apiRequestModel.setRequestBody(requestString.toJSONString());
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Accept-Encoding", "identity");
            apiRequestModel.setHeadMap(headMap);
            return apiRequestModel;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5feb\u94b1\u652f\u4ed8\u5f02\u5e38 >> iApiDefinition={}, request={}, requestBody={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), context.getIApiDefinition(), request, requestBody});
            throw new RuntimeException(e);
        }
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("kqbill-sdk");
        clientInfoModel.setClientName("\u5feb\u94b1\u652f\u4ed8");
        return clientInfoModel;
    }

    protected KqbillBizRes buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject dataJson = null;
        try {
            dataJson = JSONObject.parseObject((String)apiResponseModel.getResponseBody());
            KqbillBizRes bizRes = new KqbillBizRes();
            JSONObject resBody = dataJson.getJSONObject("responseBody");
            if (resBody != null && resBody.size() > 0) {
                String decrptBody = this.signUtil.decrypt(resBody);
                bizRes = (KqbillBizRes)JSONObject.parseObject((String)decrptBody, (Class)requestContext.getIApiDefinition().getResponseClass());
            }
            KqbillBizRes.KqbillHeaderRes headerRes = (KqbillBizRes.KqbillHeaderRes)JSONObject.parseObject((String)dataJson.getString("head"), KqbillBizRes.KqbillHeaderRes.class);
            bizRes.setHead(headerRes);
            return bizRes;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u5feb\u94b1\u652f\u4ed8\u54cd\u5e94\u5f02\u5e38 >> iApiDefinition={}, request={}, \u4e1a\u52a1\u54cd\u5e94\u62a5\u6587dataJson={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), requestContext.getIApiDefinition(), apiRequestModel.getRequest(), dataJson});
            throw new RuntimeException(e);
        }
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    public KqbillBizRes execute(KqbillBizReq request, KqbillTradeApiEnum apiDefinition) throws FsApiException {
        return (KqbillBizRes)this.doExecute(request, apiDefinition);
    }

    public KqbillBizRes execute(KqbillBizReq request, KqbillTradeApiEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected DefaultRequestContext buildRequestContext(KqbillTradeApiEnum tradeApiDefinitionEnum, KqbillBizReq request, DefaultClientConfigModel merchantConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        KqbillClientConfigModel clientConfig = this.kqbillClientConfig;
        KqbillClientConfigModel config = this.copyKqbillConfig(clientConfig);
        if (merchantConfig != null) {
            config.setAgentId(StringUtils.isEmpty((CharSequence)merchantConfig.getAgentId()) ? clientConfig.getAgentId() : merchantConfig.getAgentId());
            config.setAppId(StringUtils.isEmpty((CharSequence)merchantConfig.getAppId()) ? clientConfig.getAppId() : merchantConfig.getAppId());
            config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)merchantConfig.getFubeiPrivateKey()) ? clientConfig.getFubeiPrivateKey() : merchantConfig.getFubeiPrivateKey());
            config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)merchantConfig.getPayCompanyPublicKey()) ? clientConfig.getPayCompanyPublicKey() : merchantConfig.getPayCompanyPublicKey());
        }
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    private KqbillClientConfigModel copyKqbillConfig(KqbillClientConfigModel clientConfigModel) {
        KqbillClientConfigModel configModel = new KqbillClientConfigModel();
        configModel.setAppId(clientConfigModel.getAppId());
        configModel.setAgentId(clientConfigModel.getAgentId());
        configModel.setFubeiPrivateKey(clientConfigModel.getFubeiPrivateKey());
        configModel.setPayCompanyPublicKey(clientConfigModel.getPayCompanyPublicKey());
        configModel.setPassword(clientConfigModel.getPassword());
        configModel.setApiParentURL(clientConfigModel.getApiParentURL());
        configModel.setMd5SignKey(clientConfigModel.getMd5SignKey());
        configModel.setSignTypeEnum(clientConfigModel.getSignTypeEnum());
        configModel.setVrifySignResponse(clientConfigModel.isVrifySignResponse());
        configModel.setCheckParam(clientConfigModel.isCheckParam());
        configModel.setConnectionTimeout(clientConfigModel.getConnectionTimeout());
        configModel.setReadTimeout(clientConfigModel.getReadTimeout());
        configModel.setCharset(clientConfigModel.getCharset());
        configModel.setHump(clientConfigModel.isHump());
        configModel.setExtendParam(new HashMap(clientConfigModel.getExtendParam()));
        configModel.setSingIgnoreNull(clientConfigModel.isSingIgnoreNull());
        configModel.setSSLVersion(clientConfigModel.getSSLVersion());
        configModel.setSSLCertPath(clientConfigModel.getSSLCertPath());
        configModel.setSSLKeyStore(clientConfigModel.getSSLKeyStore());
        configModel.setSSLKeyPass(clientConfigModel.getSSLKeyPass());
        configModel.setKeyStore(clientConfigModel.getKeyStore());
        return configModel;
    }

    public JSONObject encodeStr(String data) throws Exception {
        return this.signUtil.encrypt(data);
    }

    public String decodeStr(JSONObject data) throws Exception {
        return this.signUtil.decrypt(data);
    }
}

