package com.fshows.kqbill.util;

import com.alibaba.fastjson.JSONObject;
import com.bill99.crypto.entity.Bill99CertConfig;
import com.bill99.crypto.service.CryptoService;
import com.bill99.crypto.service.processor.P7CryptoServiceProcessor;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;

public class SignUtil {
    private static CryptoService cryptoService = P7CryptoServiceProcessor.getInstance();

    public SignUtil(DefaultClientConfigModel configModel) {
        // 证书配置
        Bill99CertConfig config = new Bill99CertConfig();
        config.setBill99DefaultPublicPath(configModel.getPayCompanyPublicKey());
        config.setMerchantDefaultPrivatePath(configModel.getFubeiPrivateKey());
        config.setMerchantDefaultPrivatePassword(configModel.getPassword());
        cryptoService.setBill99CertConfig(config);
    }

    public JSONObject encrypt(String reqData) throws Exception {
        //调用加密方法
        return cryptoService.seal(reqData);
    }

    public String decrypt(JSONObject respEncryptBody) throws Exception {
        String respSignedData = respEncryptBody.getString("signedData");
        String respEnvelopedData = respEncryptBody.getString("envelopedData");
        return cryptoService.unSeal(respEnvelopedData, respSignedData);
    }
}
