/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade.detail;

import lombok.Data;

/**
 * @author wangqilei
 * @version RefundSharingData.java, v 0.1 2024-07-03 5:20 PM wangqilei
 */
@Data
public class RefundSharingData {
    /**
     * 1: 固定值，2: useId（平台合作商的唯一标识）。一级节点上送时，2必填
     * (特殊必填)
     */
    private Integer refundSharingFlag;

    /**
     * 分账编号方式
     * 固定值 2为 useId（平台合作商户在平台的唯一标识）；
     * (选填)
     */
    private String refundSharingDataContactFlag;

    /**
     * 分账方（或称平台合作商）的useId，一级节点上送时必填
     * (选填)
     */
    private String refundSharingDataContact;

    /**
     * 分账方退货金额，单位为分，大于0
     * (必填)
     */
    private String refundSharingDataAmount;

    /**
     * 可为空，备注字段，非必填
     * (特殊必填)
     */
    private String refundSharingDataMemo;
}