/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade;

import com.fshows.kqbill.request.KqbillBizReq;
import com.fshows.kqbill.request.trade.detail.GoodDetail;
import com.fshows.kqbill.request.trade.detail.SharingInfo;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author wangqilei
 * @version KqbillPayReq.java, v 0.1 2024-06-05 3:07 PM wangqilei
 */
@Data
public class KqbillJsApiPayCreateReq extends KqbillBizReq {
    /**
     * 商户在快钱的唯一标识
     */
    @NotBlank
    @Length(max = 15, message = "merchantId长度不能超过15")
    private String merchantId;

    /**
     * 快钱分配给商户的终端编号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "terminalId长度不能超过15")
    private String terminalId;

    /**
     * 交易币种，固定为CNY
     * (必填)
     */
    @NotBlank
    @Length(max = 3, message = "cur长度不能超过3")
    private String cur;

    /**
     * 订单的支付金额，单位：分
     * (必填)
     */
    @NotNull
    private String amount;

    /**
     * 01-微信小程序, 02-微信公众号, 03-支付宝服务窗, 04-支付宝小程序, 05-银联行业码
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "userAgent长度不能超过2")
    private String userAgent;

    /**
     * 商户自有应用的ID，当userAgent为01/02/03/04时必填，05时非必填，微信传入公众号或小程序appid，支付宝传入生活号或小程序号appid
     * (特殊必填)
     */
    @Length(max = 128, message = "subAppId长度不能超过128")
    private String subAppId;

    /**
     * 微信传入的openid，支付宝传入buyer_id，银联传入userAuthCode，获取方法参见相关章节
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "openId长度不能超过128")
    private String openId;

    /**
     * 当userAgent为01/02/03/04时非必填，05时必填，获取方法参见4.3.3
     * (选填)
     */
    @Length(max = 128, message = "appUpIdentifier长度不能超过128")
    private String appUpIdentifier;

    /**
     * 银联行业码支付完成后跳转的地址，userAgent为05时必填
     * (特殊必填)
     */
    @Length(max = 256, message = "frontUrl长度不能超过256")
    private String frontUrl;

    /**
     * 订单失效时间，空时默认300秒，最大不超过15天
     * (选填)
     */
    private Integer txnExpireTime;

    /**
     * 异步通知地址，非必填，需开通时告知运维人员
     * (选填)
     */
    @Length(max = 128, message = "tr3Url长度不能超过128")
    private String tr3Url;

    /**
     * 受理终端的IP地址
     * (必填)
     */
    @NotBlank
    @Length(max = 256, message = "terminalIp长度不能超过256")
    private String terminalIp;

    /**
     * 输入的附加数据，原样返回
     * (选填)
     */
    @Length(max = 128, message = "attach长度不能超过128")
    private String attach;

    /**
     * 使用分账功能时（需开通分账功能）上送，不使用分账功能时无需上送
     */
    private SharingInfo sharingInfo;

    /**
     * 商品信息列表
     */
    private List<GoodDetail> isvGoodsList;
}