package com.fshows.kqbill.handler;

import cn.hutool.core.util.StrUtil;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

import javax.net.ssl.SSLContext;

public class HttpsClientFactory {
    public CloseableHttpClient createSSLClient(HttpClientCert httpClientCert) throws Exception {
        SSLContext sslContext;
        SSLContextBuilder builder = SSLContexts.custom();
        // 加载客户端证书
        if (httpClientCert.getKeyStore() != null) {
            if (StrUtil.isEmpty(httpClientCert.getKeyStorePwd())) {
                builder = builder.loadKeyMaterial(httpClientCert.getKeyStore(), null);
            } else {
                builder = builder.loadKeyMaterial(httpClientCert.getKeyStore(), httpClientCert.getKeyStorePwd().toCharArray());
            }
        }
        // 加载服务端证书
        if (httpClientCert.getTrustStore() != null) {
            sslContext = builder.loadTrustMaterial(httpClientCert.getTrustStore(), new TrustSelfSignedStrategy()).build();
        } else {
            /**
             * 客户端验证服务端
             */
            // 信任所有
            sslContext = builder.loadTrustMaterial(null, (xcs, string) -> true).build();
        }
        SSLConnectionSocketFactory sslSocketFactory = getConnectionSocketFactory(sslContext, httpClientCert.getSSLVersion());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(Integer.valueOf(httpClientCert.getSoTimeout()))
                .setConnectTimeout(Integer.valueOf(httpClientCert.getConnTimeout())).build();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLSocketFactory(sslSocketFactory).build();
    }

    private SSLConnectionSocketFactory getConnectionSocketFactory(SSLContext sslContext, String SSLVersion) {
        if (StrUtil.isEmpty(SSLVersion)) {
            return new SSLConnectionSocketFactory(sslContext, NoopHostnameVerifier.INSTANCE);
        } else {
            return new SSLConnectionSocketFactory(sslContext, new String[]{SSLVersion}, null,
                    NoopHostnameVerifier.INSTANCE);
        }
    }


}
