/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;

/**
 * 充值记账撤销接口
 *
 * @author
 * @version FuStdTradeAllocateCancelReq.java, v 0.1 2024-01-02 15:48:19
 */
@Data
public class FuStdTradeAllocateCancelReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555693754105L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 源交易富友批次号
     * 源交易富友批次号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "batchNo长度不能超过12")
    private String batchNo;

}