/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;

/**
 * 归集关系查询接口
 *
 * @author
 * @version FuStdQueryConcentrateRelationReq.java, v 0.1 2024-01-10 15:18:03
 */
@Data
public class FuStdQueryConcentrateRelationReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555558667680L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 查询类型
     * 01:待生效商户
    02:已生效商户
    03:关系解除商户
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "type长度不能超过2")
    private String type;

    /**
     * 被归集商户号
     * 被归集商户号
     * (选填)
     */
    @Length(max = 30, message = "mchntCdConcentrate长度不能超过30")
    private String mchntCdConcentrate;

    /**
     * 授权申请号
     * 授权接口返回的申请号
     * (选填)
     */
    @Length(max = 32, message = "batchNo长度不能超过32")
    private String batchNo;

}