/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account ;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;

import javax.validation.constraints.NotBlank;


/**
 * 用户记账户余额查询接口
 *
 * @author
 * @version FuStdCustomerBalanceQueryReq.java, v 0.1 2023-12-28 17:17:48
 */
@Data
public class FuStdCustomerInBalanceQueryReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555999263930L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 用户编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn长度不能超过40")
    private String accountIn;

}