/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author mengqf
 * @version FuiouForeignCardOpenResponse.java, v 0.1 2025-05-13 17:55 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FuiouForeignCardOpenResponse extends FuiouBizResponse implements Serializable {
    private static final long serialVersionUID = -2962090590852515233L;
    /**
     * 响应结果
     * (必填)
     */
    private String retCode;

    /**
     * 响应对应中文解释
     * (必填)
     */
    private String retMsg;

    /**
     * 商户号
     * (必填)
     */
    private String mchntCd;

    /**
     * 商户变更单号
     * (必填)
     */
    private String modifyNo;

    /**
     * 请求交易流水
     * (必填)
     */
    private String traceNo;
}