/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.response.coupon;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author mengqf
 * @version FuiouCouponTransferResponse.java, v 0.1 2024-08-16 16:49 mengqf
 */
@Data
public class FuiouCouponTransferResponse extends FuiouBizResponse implements Serializable {
    private static final long serialVersionUID = -6084603452396230179L;

    /**
     * 唯一流水号
     * (必填)
     */
    private String traceNo;

    /**
     * 营销账号-转出的商户号
     * (必填)
     */
    private String accountIn;

    /**
     * 入账商户号
     * (必填)
     */
    private String mchntCd;

    /**
     * 手续费
     */
    private Integer feeAmt;

    /**
     * 转账金额
     */
    private Integer txnAmt;

    /**
     * 转账类型
     * 1：营销
     * 2: 核销转账
     * (必填)
     */
    private String transType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 富友交易参考号
     */
    private String fasSsn;

    /**
     * 转账日期 yyyyMMdd
     */
    private String fasDate;
}