/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.*;
import com.fshows.fuiou.request.base.*;
import com.fshows.fuiou.response.merchant.*;
import lombok.*;

import javax.validation.constraints.*;
import java.io.*;

/**
 * @author
 * @version FuiouRateUpdateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouRateUpdateRequest extends FuiouBizRequest<FuiouRateUploadResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555552344858L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 已在富友入网的富友商户代码
     * (必填)
     */
    @NotBlank
    private String fyMchntCd;

    /**
     * 二级代理机构号
     * (选填)
     */
    private String subInsCd;

    /**
     * 银联凭条打印名称
     * (必填)
     */
    @NotBlank
    private String printReceipt;

    /**
     * 商户子类型（MCC）
     * (必填)
     */
    @NotBlank
    private String mchntSubTp;

    /**
     * 商户英文名
     * (必填)
     */
    @NotBlank
    private String mchntEnName;

    /**
     * 商户简称英文名
     * (必填)
     */
    @NotBlank
    private String mchntEnShortname;

    /**
     * 是否开通pos(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    private String isOpenPos;

    /**
     * 借记卡扣率（开通时必填）
     * (选填)
     */
    private String posDebitCardSetCd;

    /**
     * 贷记卡扣率（开通时必填）
     * (选填)
     */
    private String posCreditCardSetCd;

    /**
     * 借记卡活动扣率
     * (选填)
     */
    private String posActDebitCardSetCd;

    /**
     * 贷记卡活动扣率
     * (选填)
     */
    private String posActCreditCardSetCd;

    /**
     * 刷卡预授权(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    private String posPreAuth;

    /**
     * 是否开通受理预付卡(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    private String prepayAllowInd;

    /**
     * 预付卡费率
     * (选填)
     */
    private String prepaySetCd;

    /**
     * 是否开通银联二维码(1开通，0关闭)
     * (必填)
     */
    @NotBlank
    private String cupQrpaySt;

    /**
     * 借记卡扣率（开通时必填）
     * (选填)
     */
    private String debitCardSetCd;

    /**
     * 贷记卡扣率（开通时必填）
     * (选填)
     */
    private String creditCardSetCd;

    /**
     * 借记卡活动扣率
     * (选填)
     */
    private String actDebitCardSetCd;

    /**
     * 贷记卡活动扣率
     * (选填)
     */
    private String actCreditCardSetCd;

    /**
     * 1：电子协议（人脸识别，使用需对接“富友商户认证”配套接口）
     * 0：纸质协议
     * 默认为0纸质协议-传1，电子协议
     */
    private String certificateFlag;

    /**
     * 变更描述即变更备注，富友在审核时，可以看到的文字描述-写死为商户申请开通刷卡权限
     */
    private String modifyDesc;
}