package com.fshows.fuiou.request.merchant; /**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouMerchantSignResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouMerchantSignRequest.java, v 0.1 2024-11-27 09:50:57
 */
@Data
public class FuiouMerchantSignRequest extends FuiouBizRequest<FuiouMerchantSignResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555963547947L;


    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;

    /**
     * 富友商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "traceNo长度不能超过32")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 法人手机号（用于接收认证短信和签约短信）
     * (必填)
     */
    @NotBlank
    @Length(max = 11, message = "certifPhone长度不能超过11")
    @JSONField(name = "certif_phone")
    private String certifPhone;

    /**
     * 认证类型: 1：人脸识别H5 2：要素验证
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "authType长度不能超过1")
    @JSONField(name = "auth_type")
    private String authType;

    /**
     * 触达类型 1：合作方（签约url接口返回给合作方） 2：商户（签约url短信发送给法人手机号）
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "reachType长度不能超过1")
    @JSONField(name = "reach_type")
    private String reachType;

    /**
     * 用于接收签约结果的回调地址(推荐https地址), 回调请求参数名req，详细见notfiy_url 异步通知报文
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "notifyUrl长度不能超过64")
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * 用户完成或取消验证后网页跳转的目标URL (推荐https页面，触达类型=1合作方时填写)
     * (选填)
     */
    @Length(max = 64, message = "frontReturnUrl长度不能超过64")
    @JSONField(name = "front_return_url")
    private String frontReturnUrl;

}